/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionElement;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWPersistentCollection;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.server.VWQueryResults;
import filenet.vw.server.VWWorkRecord;
import java.io.Serializable;
import java.lang.reflect.Array;

abstract class VWQuery
implements Serializable {
    private static final long serialVersionUID = 7511L;
    public static final int QUERY_NO_OPTIONS = 0;
    public static final int QUERY_READ_LOCKED = 1;
    public static final int QUERY_READ_BOUND = 2;
    public static final int QUERY_READ_UNWRITABLE = 4;
    public static final int QUERY_LOCK_OBJECTS = 16;
    public static final int QUERY_MIN_VALUES_INCLUSIVE = 32;
    public static final int QUERY_MAX_VALUES_INCLUSIVE = 64;
    public static final int QUERY_GET_SYSTEM_FIELDS = 256;
    public static final int QUERY_GET_TRANSLATED_SYSTEM_FIELDS = 512;
    public static final int QUERY_GET_NO_SYSTEM_FIELDS = 1024;
    public static final int QUERY_GET_NO_TRANSLATED_SYSTEM_FIELDS = 2048;
    public static final int QUERY_RESOLVE_NAMES = 8192;
    public static final int QUERY_TRANSLATE_QUERY_FILTER = 8192;
    protected int fetchType = -1;
    protected VWPersistentCollection querySource;
    protected int bufferSize;
    protected String indexName;
    protected Object[] minValues;
    protected Object[] maxValues;
    protected int queryFlags;
    protected String filterSQL;
    protected int queryType;
    protected Object[] substitutionVars;
    protected VWWorkRecord lastRecord;
    protected double rpUniqueId;
    protected boolean queryIsOver;
    protected int queryFetchType = -1;
    protected boolean auditOn = false;
    protected Object[] fetchedObjects = null;
    protected int returnCount = 0;
    protected int fetchCount = 0;
    protected boolean userBoundQueueQuery = false;
    protected String sortColumn = null;
    protected String[] wbFilterNames = null;
    protected int workBasketId = -1;

    public static String _get_FILE_DATE() {
        return "$Date: 2009-09-29 22:19:27 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/1 $";
    }

    protected VWQuery(VWPersistentCollection query_source, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String filter_SQL, Object[] substitution_Vars, int query_Type) throws VWException {
        this.bufferSize = 50;
        this.queryIsOver = false;
        this.lastRecord = null;
        this.rpUniqueId = 0.0;
        this.querySource = query_source;
        this.indexName = index_Name;
        this.minValues = min_Values;
        this.maxValues = max_Values;
        this.queryFlags = query_Flags;
        this.filterSQL = filter_SQL;
        this.queryType = query_Type;
        this.substitutionVars = substitution_Vars;
        if (this.filterSQL != null && this.filterSQL.length() > 0 && this.substitutionVars != null) {
            int index = 0;
            int indexCount = 0;
            int index1 = -99;
            int index2 = -99;
            index = this.filterSQL.indexOf(58);
            while (index != -1 && index < this.filterSQL.length() + 1) {
                if ((query_Flags & 0x2000) == 8192) {
                    if (index1 == -99 && index1 != -1) {
                        index1 = this.filterSQL.indexOf("{{:1", index - 3);
                    }
                    if (index2 == -99 && index2 != -1) {
                        index2 = this.filterSQL.indexOf("{{:2", index - 3);
                    }
                    if (index1 != index && index2 != index) {
                        ++indexCount;
                    }
                } else {
                    ++indexCount;
                }
                index = this.filterSQL.indexOf(58, index + 1);
            }
            if (indexCount != this.substitutionVars.length) {
                throw new VWException("vw.api.VWQueryBadSubVars", "Number of elements in the substitution variables array does not match the number of substitution variables ('':'') in the filter string.");
            }
        }
    }

    protected int mapQueryFlags(int query_Flags) {
        int queryFlags = (query_Flags & 0x800) == 2048 && (query_Flags & 0x400) == 1024 ? query_Flags : ((query_Flags & 0x400) == 1024 ? query_Flags | 0x200 : ((query_Flags & 0x800) == 2048 ? query_Flags | 0x100 : query_Flags | 0x100 | 0x200));
        return queryFlags;
    }

    protected VWQuery(VWPersistentCollection query_source, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String filter_SQL, Object[] substitution_Vars, int query_Type, int buffer_Size, int fetch_Type) throws VWException {
        this.bufferSize = 1;
        this.queryIsOver = false;
        this.lastRecord = null;
        this.rpUniqueId = 0.0;
        this.querySource = query_source;
        this.indexName = index_Name;
        this.minValues = min_Values;
        this.maxValues = max_Values;
        this.queryFlags = this.mapQueryFlags(query_Flags);
        this.filterSQL = filter_SQL;
        this.queryType = query_Type;
        this.fetchType = fetch_Type;
        this.queryFetchType = fetch_Type;
        this.bufferSize = buffer_Size;
        this.substitutionVars = substitution_Vars;
        if (this.filterSQL != null && this.filterSQL.length() > 0 && this.substitutionVars != null) {
            int index = 0;
            int indexCount = 0;
            int index1 = -99;
            int index2 = -99;
            index = this.filterSQL.indexOf(58);
            while (index != -1 && index < this.filterSQL.length() + 1) {
                if ((query_Flags & 0x2000) == 8192) {
                    if (index1 == -99 && index1 != -1) {
                        index1 = this.filterSQL.indexOf("{{:1", index - 3);
                    }
                    if (index2 == -99 && index2 != -1) {
                        index2 = this.filterSQL.indexOf("{{:2", index - 3);
                    }
                    if (index1 != index && index2 != index) {
                        ++indexCount;
                    }
                } else {
                    ++indexCount;
                }
                index = this.filterSQL.indexOf(58, index + 1);
            }
            if (indexCount != this.substitutionVars.length) {
                throw new VWException("vw.api.VWQueryBadSubVars", "Number of elements in the substitution variables array does not match the number of substitution variables ('':'') in the filter string.");
            }
        }
    }

    protected VWQuery(VWPersistentCollection query_source, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String filter_SQL, Object[] substitution_Vars, int query_Type, int buffer_Size, int fetch_Type, String sort_Column, String[] wbFilter_Names, int workBasket_Id) throws VWException {
        this.bufferSize = 1;
        this.queryIsOver = false;
        this.lastRecord = null;
        this.rpUniqueId = 0.0;
        this.querySource = query_source;
        this.indexName = index_Name;
        this.minValues = min_Values;
        this.maxValues = max_Values;
        this.queryFlags = this.mapQueryFlags(query_Flags);
        this.filterSQL = filter_SQL;
        this.queryType = query_Type;
        this.fetchType = fetch_Type;
        this.queryFetchType = fetch_Type;
        this.bufferSize = buffer_Size;
        this.substitutionVars = substitution_Vars;
        if (this.filterSQL != null && this.filterSQL.length() > 0 && this.substitutionVars != null) {
            int index = 0;
            int indexCount = 0;
            int index1 = -99;
            int index2 = -99;
            index = this.filterSQL.indexOf(58);
            while (index != -1 && index < this.filterSQL.length() + 1) {
                if ((query_Flags & 0x2000) == 8192) {
                    if (index1 == -99 && index1 != -1) {
                        index1 = this.filterSQL.indexOf("{{:1", index - 3);
                    }
                    if (index2 == -99 && index2 != -1) {
                        index2 = this.filterSQL.indexOf("{{:2", index - 3);
                    }
                    if (index1 != index && index2 != index) {
                        ++indexCount;
                    }
                } else {
                    ++indexCount;
                }
                index = this.filterSQL.indexOf(58, index + 1);
            }
            if (indexCount != this.substitutionVars.length) {
                throw new VWException("vw.api.VWQueryBadSubVars", "Number of elements in the substitution variables array does not match the number of substitution variables ('':'') in the filter string.");
            }
        }
    }

    protected VWPersistentCollection getSource() {
        return this.querySource;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int newSize) throws VWException {
        if (newSize < 1) {
            throw new VWException("vw.api.VWQueryfetchBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        this.bufferSize = newSize;
    }

    protected boolean endOfQuery() {
        return this.queryIsOver;
    }

    protected VWWorkElement[] fetch(int typeToFetch, Class elementType) throws VWException {
        int i;
        int arrCount;
        Object resultArray = Array.newInstance(elementType, 0);
        if (this.queryIsOver) {
            return (VWWorkElement[])resultArray;
        }
        Object array = Array.newInstance(elementType, this.bufferSize);
        int arrayLength = 0;
        int fetchSize = this.bufferSize;
        for (arrCount = 0; !this.queryIsOver && arrCount < this.bufferSize; arrCount += arrayLength) {
            VWQueryResults results = this.querySource.cmdSession.fetch(this.querySource.viewId, this.queryType, typeToFetch, fetchSize, this.indexName, this.minValues, this.maxValues, this.queryFlags, this.filterSQL, this.substitutionVars, this.lastRecord, this.rpUniqueId, this.userBoundQueueQuery, this.querySource.getAuthoredName(), this.workBasketId, this.sortColumn, this.wbFilterNames);
            if (results == null) {
                throw new VWException("vw.api.VWQueryFetchNullResults", "Null results returned from server fetch");
            }
            this.lastRecord = results.lastRecord;
            this.rpUniqueId = results.rpUniqueId;
            this.queryIsOver = results.queryFinished;
            arrayLength = 0;
            if (results.workObjectIds != null) {
                arrayLength = results.workObjectIds.length;
                if (!this.queryIsOver) {
                    fetchSize -= arrayLength;
                }
            }
            try {
                for (i = 0; i < arrayLength; ++i) {
                    Array.set(array, arrCount + i, elementType == VWWorkObject.class ? new VWWorkObject(results.fieldValues[i], results.workObjectIds[i], this) : (elementType == VWInstructionElement.class ? new VWInstructionElement(results.fieldValues[i], results.workObjectIds[i], this) : (elementType == VWQueueElement.class ? new VWQueueElement(results.fieldValues[i], results.workObjectIds[i], this) : (elementType == VWRosterElement.class ? new VWRosterElement(results.fieldValues[i], results.workObjectIds[i], this) : (elementType == VWStepElement.class ? new VWStepElement(results.fieldValues[i], results.workObjectIds[i], this) : (elementType == VWLogElement.class ? new VWLogElement(results.fieldValues[i], results.workObjectIds[i], this) : null))))));
                }
                continue;
            }
            catch (Exception e) {
                throw new VWException("vw.api.VWQueryConstructionFailure", "A problem occurred while constructing work elements. {0}", e.getMessage());
            }
        }
        if (arrCount != 0 && arrCount < this.bufferSize) {
            resultArray = Array.newInstance(elementType, arrCount);
            for (i = 0; i < arrCount; ++i) {
                Array.set(resultArray, i, Array.get(array, i));
            }
        } else if (arrCount == this.bufferSize) {
            resultArray = array;
        }
        return (VWWorkElement[])resultArray;
    }

    protected void resetFetch() {
        this.queryIsOver = false;
        this.lastRecord = null;
        this.rpUniqueId = 0.0;
        this.returnCount = 0;
        this.fetchCount = 0;
        this.fetchedObjects = null;
    }

    protected void dofetch() throws VWException {
    }

    protected boolean hasNext() throws VWException {
        boolean result = true;
        if (this.returnCount == this.fetchCount) {
            if (this.endOfQuery()) {
                result = false;
            } else {
                this.dofetch();
                result = this.returnCount < this.fetchCount;
            }
        }
        return result;
    }

    protected void setUserBoundQueueQuery(boolean userBoundQuery) {
        this.userBoundQueueQuery = userBoundQuery;
    }

    protected int fetchCount(String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String filter_SQL, Object[] substitution_Vars, int query_Type, int typeToFetch, String sort_Column, String[] wbFilter_Names, int workBasket_Id) throws VWException {
        Integer IResults = this.querySource.cmdSession.fetchCount(this.querySource.viewId, query_Type, typeToFetch, index_Name, min_Values, max_Values, query_Flags, filter_SQL, substitution_Vars, this.userBoundQueueQuery, this.querySource.getAuthoredName(), this.workBasketId, this.sortColumn, wbFilter_Names);
        if (IResults == null) {
            throw new VWException("vw.api.VWQueryFetchNullResults", "Null results returned from server fetch");
        }
        return IResults;
    }

    protected int fetchCount(int typeToFetch) throws VWException {
        Integer IResults = this.querySource.cmdSession.fetchCount(this.querySource.viewId, this.queryType, typeToFetch, this.indexName, this.minValues, this.maxValues, this.queryFlags, this.filterSQL, this.substitutionVars, this.userBoundQueueQuery, this.querySource.getAuthoredName(), this.workBasketId, this.sortColumn, this.wbFilterNames);
        if (IResults == null) {
            throw new VWException("vw.api.VWQueryFetchNullResults", "Null results returned from server fetch");
        }
        return IResults;
    }
}

